#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
import subprocess
import os

def tables():
   # return a tuple of smash tables file names
   return ( 'buckets', 'slots', 'conquer.1', 'conquer.2' )

# We can't trust stat's st_blocks on all filesystems.
stBlocksSupported = None

# Number of bytes allocated for the file. On filesystems that don't
# support st_blocks we instead used st_size.
def memSize( fileName ):
   global stBlocksSupported
   if stBlocksSupported == None: # pylint: disable=singleton-comparison
      dfOutput = subprocess.check_output( [ 'df', '-T', fileName ],
                                          universal_newlines=True )
      stBlocksSupported = 'tmpfs' in dfOutput or 'ext4' in dfOutput
   if stBlocksSupported:
      return os.stat( fileName ).st_blocks * 512
   else:
      return os.stat( fileName ).st_size

