# Copyright (c) 2010 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

def enableNetSnmpDebug( debugTokens, snmpAgentRoot ):
   ''' 
   NET-SNMP code allows us to enable debug for the snmp library
   code and snmpd code, by passing multiple debug tokens. This function
   takes the tokens (comma separated) and calls the wrapper library
   to enable the debug option.
   '''
   netSnmpDebug = snmpAgentRoot[ 'netSnmpDebug' ]

   assert netSnmpDebug
   netSnmpDebug.doDebugRegisterTokens( debugTokens )
   netSnmpDebug.snmpDoDebugging = True
