# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import Tracing

t0 = Tracing.trace0

# Copied from SnmpNotificationRegistrar -
# should there be a common implementation somewhere?
def isMasterSysdb( entityManager ):
   redundancyStatus = entityManager.redundancyStatus()
   if not ( redundancyStatus.protocol == 'sso' and
             redundancyStatus.mode == 'standby' ):
      return True
   return False

def registerDisableObjects( entityManager,
                         name,
                         description ):
   """
   Used by DefaultConfig plug-ins to register units to disable.

   @entityManager - The entity manager passed from DefaultConfigPlugins
   @name - The name of the unit that can be disabled
   @description - Description of the unit that can be disabled
   """

   if not isMasterSysdb( entityManager ):
      return

   config = entityManager.lookup( 'snmp/config' )
   config.newDisableObjectsConfig( name, description )
