#!/usr/bin/env python3
# Copyright (c) 2008 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import re

import ArPyUtils

# PEN assigned to Arista Networks by IANA; see AID 285.
aristaPen = 30065

def objectIdFromModelName( modelName ):
   """Generates the sysObjectID value from a model name."""
   if modelName == "":
      return "0.0"
   # pylint: disable-next=consider-using-f-string
   oidPrefix = "1.3.6.1.4.1.%d.1" % aristaPen
   oid = oidPrefix.split( "." )
   components = re.findall( r"(0+|[1-9]\d*|[A-Za-z]+)", modelName )
   for c in components:
      if re.match( "[1-9]", c ):
         oid.append( c )
      else:
         # oid components are ints, so hash the string to a 12-bit int
         oid.append( str( abs( ArPyUtils.py2StringHash( c ) ) % 4096 ) )
   objectId = ".".join( oid )
   return objectId
