# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import SharedMem
import Tracing

handle = Tracing.Handle( 'AleCountersSnmp' )
t0 = handle.trace0

class AleCountersSnmpPlugin:
   def __init__( self, ctx ):
      entityManager = ctx.entityManager()
      self.entityManager_ = entityManager
      sysdb = entityManager.root()
      snmpRoot = sysdb.parent[ 'snmp' ]
      mibDir = snmpRoot.mkdir( 'aleCounters' )
      mib = mibDir.newEntity( 'AleCountersSnmp::AsicCountersMib', 'asicCountersMib' )

      snmpAgentRoot = sysdb.parent[ 'Snmp' ]
      self.root_ = None

      shmemEm = SharedMem.entityManager( sysdbEm=entityManager )

      def _finishMounts():
         self.root_ = snmpAgentRoot.newEntity( 'AleCountersSnmp::Root',
                                               'AleCountersSnmp' )
         self.root_.asicCountersMib = mib
         self.root_.shmemEm = shmemEm
         self.root_.dropCounterAgent = ( mib, shmemEm )

      ctx.callbackIs( _finishMounts )

def Plugin( ctx ):
   t0( 'Loading AleCountersSnmp plugin' )
   AleCountersSnmpPlugin( ctx )
