# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Plugins

class E911SnmpPlugin:
   def __init__( self, ctx ):
      entityManager = ctx.entityManager()
      self.entityManager_ = entityManager
      sysdb = entityManager.root()
      snmpRoot = sysdb.parent[ 'snmp' ]
      snmpAgentRoot = sysdb.parent[ 'Snmp' ]
      e911Mib = snmpRoot.newEntity( 'E911Snmp::E911Mib', 'e911' )
      ifMib = snmpRoot[ 'intf' ][ 'ifmib' ]
      mg = self.entityManager_.mountGroup()
      cdpStatus = mg.mount( "l2discovery/cdp/status", "Cdp::CdpStatus", "r" )
      self.agent_ = None

      def _finishMounts():
         self.agent_ = snmpAgentRoot.newEntity( 'E911Snmp::Agent', 'E911Snmp' )
         self.agent_.ifMib = ifMib
         self.agent_.cdpStatus = cdpStatus
         self.agent_.e911Mib = e911Mib
         self.agent_.remTableSm = ( self.agent_.cdpStatus, self.agent_.ifMib,
                                    self.agent_.e911Mib,
                                    self.agent_.smControl )

      mg.close( lambda: None )
      ctx.callbackIs( _finishMounts )

@Plugins.plugin( requires=( 'snmp/intf', ) )
def Plugin( ctx ):
   E911SnmpPlugin( ctx )
