#!/usr/bin/env python3
# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import Tracing

t0 = Tracing.trace0

class ExternalAlarmSnmpPlugin:
   def __init__( self, ctx ):
      entityManager = ctx.entityManager()
      sysdb = entityManager.root()
      snmpRoot = sysdb.parent[ 'snmp' ]
      snmpAgentRoot = sysdb.parent[ 'Snmp' ]
      externalAlarmRootDir = snmpRoot.mkdir( 'externalAlarm' )
      self.externalAlarmMib_ = externalAlarmRootDir.newEntity(
         'ExternalAlarm::Snmp::ExternalAlarmMib', 'externalAlarmMib' )
      mg = entityManager.mountGroup()
      self.externalAlarmCliConfigDir_ = mg.mount(
         'hardware/externalAlarm/cliConfig', 'Hardware::ExternalAlarm::CliConfigDir',
         'r' )
      self.externalAlarmStatusDir_ = mg.mount( 'hardware/externalAlarm/status',
                                               'Hardware::ExternalAlarm::StatusDir',
                                               'r' )
      self.externalAlarmConfigDir_ = mg.mount( 'hardware/externalAlarm/config',
                                               'Hardware::ExternalAlarm::Config',
                                               'r' )
      self.root_ = None

      def _finishMounts():
         self.root_ = snmpAgentRoot.newEntity( 'ExternalAlarm::Snmp::Root',
                                               'ExternalAlarmSnmp' )
         self.root_.externalAlarmSm = ( self.externalAlarmStatusDir_,
                                        self.externalAlarmCliConfigDir_,
                                        self.externalAlarmConfigDir_,
                                        self.externalAlarmMib_ )
      mg.close( lambda: None )
      ctx.callbackIs( _finishMounts )

def Plugin( ctx ):
   t0( 'Loading ExternalAlarm SnmpPlugin...' )
   ExternalAlarmSnmpPlugin( ctx )
   Tac.dlopen( 'libExternalAlarmSnmp.so' )
