# Copyright (c) 2008, 2009, 2010 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import SharedMem
import Smash
import Plugins

class LagSnmpPlugin:
   def __init__( self, ctx ):
      entityManager = ctx.entityManager()
      self.entityManager_ = entityManager
      sysdb = entityManager.root()
      snmpRoot = sysdb.parent[ 'snmp' ]
      lagRoot = snmpRoot.mkdir( 'lag' )
      ifMib = snmpRoot[ 'intf' ][ 'ifmib' ]
      ifStackTable = lagRoot.newEntity( 'LagSnmp::IfStackTable',
                                                'ifstacktable' )
      lagMib = lagRoot.newEntity( 'LagSnmp::LagMib',
                                                'lagmib' )
      self.root_ = None

      mg = entityManager.mountGroup()
      allIntfStatusDir = mg.mount( 'interface/status/all',
                        'Interface::AllIntfStatusDir', 'r' )
      phyIntfStatusDir = mg.mount( 'interface/status/eth/phy/all',
                        'Interface::AllEthPhyIntfStatusDir', 'r' )
      lagIntfStatusDir = mg.mount( 'interface/status/eth/lag',
                        'Interface::EthLagIntfStatusDir', 'r' )
      lagConfig = mg.mount( 'lag/config',
                        'Lag::Config', 'r' )
      lacpConfig = mg.mount( 'lag/lacp/config',
                        'Lacp::Config', 'r' )
      lacpStatus = mg.mount( 'lag/lacp/status',
                        'Lacp::LacpStatus', 'r' )
      lacpCounters = mg.mount( 'lag/lacp/counters',
                        'Lacp::LacpCounters', 'r' )
      lagInputStatus = mg.mount( 'lag/input/interface/lag',
                                 'Lag::Input::EthLagIntfStatusDir', 'r' )
      shmemEm = SharedMem.entityManager( sysdbEm=entityManager )
      smi = Smash.mountInfo( 'reader' )
      lagCounter = shmemEm.doMount( 'interface/counter/lag/current',
                                    'Smash::Interface::AllIntfCounterDir', smi )

      snmpAgentRoot = sysdb.parent[ 'Snmp' ]

      def _finishMounts():
         self.root_ = snmpAgentRoot.newEntity( 'LagSnmp::Agent::Root',
                                'LagSnmp' )
         self.root_.agent = ( allIntfStatusDir, phyIntfStatusDir,
                              lagIntfStatusDir, lagConfig, lacpConfig,
                              lacpStatus, lacpCounters,
                              ifStackTable, lagMib,
                              snmpAgentRoot[ 'root' ].scheduler,
                              ifMib )

         lagInputStatus.counterDir = lagCounter

      mg.close( lambda: None )
      ctx.callbackIs( _finishMounts )

@Plugins.plugin( requires=( 'snmp/intf', ) )
def Plugin( ctx ):
   LagSnmpPlugin( ctx )
   Tac.dlopen( 'libLagSnmp.so' )
