# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Plugins
import Tracing
import Tac
import SharedMem

handle = Tracing.Handle( 'MacsecSnmp' )
t0 = handle.trace0

class MacsecSnmpPlugin:
   def __init__( self, ctx ):
      entityManager = ctx.entityManager()
      self.entityManager_ = entityManager
      sysdb = entityManager.root()
      snmpRoot = sysdb.parent[ 'snmp' ]
      macsecRoot = snmpRoot.mkdir( 'macsec' )
      macsecMib = macsecRoot.newEntity( 'MacsecSnmp::MacsecMib', 'macsecmib' )
      ifMib = snmpRoot[ 'intf' ][ 'ifmib' ]

      mg = entityManager.mountGroup()
      macsecStatus = mg.mount( 'macsec/status', 'Macsec::Status', 'r' )
      phyStatusDir = mg.mount( 'hardware/phy/status/macsec/slice',
                               'Tac::Dir', 'ri' )

      shMemEm = SharedMem.entityManager( sysdbEm=entityManager )

      macsecAgentRoot = sysdb.parent[ 'Snmp' ]
      self.root_ = None

      def _finishMounts():
         self.root_ = macsecAgentRoot.newEntity( 'MacsecSnmp::Agent::Root',
               'MacsecSnmp' )
         # MacsecSnmp agent constructor;
         self.root_.agent = ( macsecStatus, macsecMib, ifMib, shMemEm,
                              phyStatusDir )

      mg.close( lambda: None )
      ctx.callbackIs( _finishMounts )

@Plugins.plugin( requires=( 'snmp/intf', ) )
def Plugin( ctx ):
   t0( 'Loading MacsecSnmp plugin' )
   MacsecSnmpPlugin( ctx )
