# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import Cell
import Tracing

traceHandle = Tracing.Handle( 'MiscSnmp' )
t0 = traceHandle.trace0

class MiscSnmpPlugin:
   def __init__( self, ctx ):
      entityManager = ctx.entityManager()
      self.entityManager_ = entityManager
      sysdb = entityManager.root()
      snmpRoot = sysdb.parent[ 'snmp' ]
      miscRoot = snmpRoot.mkdir( 'misc' )
      generalMib = miscRoot.newEntity( 'MiscSnmp::GeneralMib', 'generalMib' )

      # pkgdeps: rpmwith %{_libdir}/preinit/SysdbReloadCauseAgent
      mg = entityManager.mountGroup()
      curCellResetHistory = mg.mount( f"cell/{Cell.cellId()}/sys/reset/history",
                                      "System::ResetCauseHistory", "r" )
      curCellReloadCause = mg.mount( f"cell/{Cell.cellId()}/sys/reload/cause",
                                     "System::ReloadCause", "r" )
      # redundancy/status is already mounted through CAgent layer
      redundancyStatus = entityManager.lookup( Cell.path( 'redundancy/status' ) )
      snmpAgentRoot = sysdb.parent[ 'Snmp' ]
      self.root_ = None

      def _finishMounts():
         self.root_ = snmpAgentRoot.newEntity( 'MiscSnmp::Agent::Root',
                                               'MiscSnmp' )
         self.root_.agent = ( redundancyStatus,
                              generalMib,
                              curCellResetHistory,
                              curCellReloadCause,
                              self.entityManager_.cEntityManager(),
                              Cell.cellType() )

      mg.close( lambda: None )
      ctx.callbackIs( _finishMounts )

def Plugin( ctx ):
   t0( 'Loading MiscSnmp SnmpPlugin' )
   MiscSnmpPlugin( ctx )
