# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import SharedMem
import Shark
import Smash
import Tac
import Tracing
from AleFlexCounterTableMounter import tableMountPath

handle = Tracing.Handle( 'MplsSnmp' )
t0 = handle.trace0

AllFapsId = Tac.Type( 'FlexCounters::FapId' ).allFapsId
FeatureId = Tac.Type( 'FlexCounters::FeatureId' )
RsvpLerSysdbStatus = Tac.Type( 'Rsvp::RsvpLerSysdbStatus' )

class MplsSnmpPlugin:
   def __init__( self, ctx ):
      self.em_ = ctx.entityManager()
      sysdb = self.em_.root()
      snmpRoot = sysdb.parent[ 'snmp' ]
      mibDir = snmpRoot.mkdir( 'mpls' )
      mib = mibDir.newEntity( 'MplsSnmp::MplsTeMib', 'mplsTeMib' )
      # Entity that contains the SMs to manage mplsTunnelHopTable
      hopTableHelper = Tac.newInstance( 'MplsSnmp::HopTableHelper' )

      snmpAgentRoot = sysdb.parent[ 'Snmp' ]
      self.root_ = None

      mg = self.em_.mountGroup()
      # "mpls/rsvp/lerStatus"
      rsvpLerStatus = mg.mount( RsvpLerSysdbStatus.mountPath,
                                'Rsvp::RsvpLerSysdbStatus', 'r' )
      shmemEm = SharedMem.entityManager( sysdbEm=self.em_ )
      # Shark mount must use mount group (no inline option like in Smash where you
      # can call shmemEm.doMount directly), and the type must be shadow, no passive
      # reader yet
      shmemMg = shmemEm.getMountGroup()
      rsvpSharkStatus = shmemMg.doMount( 'mpls/rsvp/status', 'Rsvp::RsvpSharkStatus',
                                         Shark.mountInfo( 'shadow' ) )

      # Smash table for mpls tunnel counters (mplsTunnelPerfTable)
      path = tableMountPath( self.em_, FeatureId.Nexthop, AllFapsId, False )
      smi = Smash.mountInfo( 'reader' )
      mplsTunnelCounterTable = shmemEm.doMount( path, 'FlexCounters::CounterTable',
                                                smi )

      def _finishMounts():
         t0( 'MplsSnmpPlugin finish mounts' )
         self.root_ = snmpAgentRoot.newEntity( 'MplsSnmp::Root', 'MplsSnmp' )
         self.root_.rsvpTeSnmpAgent = ( mib, hopTableHelper,
                                        rsvpLerStatus, rsvpSharkStatus,
                                        mplsTunnelCounterTable )

      mg.close( lambda: None )
      shmemMg.doClose()
      ctx.callbackIs( _finishMounts )

def Plugin( ctx ):
   t0( 'Loading MplsSnmp plugin' )
   MplsSnmpPlugin( ctx )
