# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import Arnet
from Arnet import IpGenAddr
from SrTePolicyLib import tacProtocol

def EndPoint( ipString ):
   return Arnet.IpGenAddr( str( ipString ) )

def Color( value ):
   return tacColor( value )

def PolicyKey( ep, c ):
   endPoint = EndPoint( ep )
   color = Color( c )
   return Tac.const( tacPolicyKey( endPoint, color ) )

def cbfFecOverrideMapPath():
   return 'te/segmentrouting/cbfFecOverrideMap'

def srTePolicyStatusPath():
   return 'srTePolicy/PolicyStatus'

def ReplicationSegmentKey( repId, node=None, root=None,
      treeId=0, instanceId=0, protocol=tacProtocol.staticProtocol ):
   nodeAddress = IpGenAddr()
   rootAddress = IpGenAddr()
   if node:
      nodeAddress = IpGenAddr( node )
   if root:
      rootAddress = IpGenAddr( root )
   return tacReplicationSegmentKey( protocol, rootAddress, treeId,
         instanceId, repId, nodeAddress )


tacColor = Tac.Type( 'TrafficEngineering::Color' )
tacPolicyKey = Tac.Type( 'SrTePolicy::PolicyKey' )
tacEnlp = Tac.Type( 'SrTePolicy::Enlp' )
tacEnlpEnum = Tac.Type( 'SrTePolicy::Enlp::Enum' )
tacReplicationSegmentKey = Tac.Type( 'SrTePolicy::SrP2mp::ReplicationSegmentKey' )
tacDownstreamNode = Tac.Type( 'SrTePolicy::SrP2mp::DownstreamNode' )
