# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac

def Preference( value=None ):
   if value is None:
      return tacPreference()
   else:
      return tacPreference( value )

def Weight( value=None ):
   if value is None:
      return tacWeight( )
   else:
      return tacWeight( value )

MplsLabelOperation = Tac.Type( 'Arnet::MplsLabelOperation' )
DownstreamNode = Tac.Type( 'SrTePolicy::SrP2mp::DownstreamNode' )
MplsLabel = Tac.Type( 'Arnet::MplsLabel' )
AddressFamily = Tac.Type( 'Arnet::AddressFamily' )
IpAddr = Tac.Type( 'Arnet::IpAddr' )

tacPreference = Tac.Type( 'SrTePolicy::Preference' )
tacWeight = Tac.Type( 'SrTePolicy::Weight' )
tacOriginator = Tac.Type( 'SrTePolicy::Originator' )
tacProtocol = Tac.Type( 'SrTePolicy::Protocol' )
tacSegmentListId = Tac.Type( 'SrTePolicy::SegmentListId' )
tacCandidateId = Tac.Type( 'SrTePolicy::CandidateId' )
tacPolicyId = Tac.Type( 'SrTePolicy::PolicyId' )
tacPolicyInvalidReason = Tac.Type( 'SrTePolicy::PolicyInvalidReason' )
tacPolicyCostMetric = Tac.Type( 'SrTePolicy::PolicyCostMetric' )

def policySrcToString( src, capitalizedFirst=False ):
   if src == tacProtocol.staticProtocol:
      if capitalizedFirst:
         return "Static"
      return "static"
   elif src == tacProtocol.bgpProtocol:
      if capitalizedFirst:
         return "BGP"
      return "bgp"
   elif src == tacProtocol.pcepProtocol:
      if capitalizedFirst:
         return "Pcep"
      return "pcep"
   return "unknown"
