#!/usr/bin/env python3
# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import AsuPStore

class SsrPStoreContext( AsuPStore.AsuPStoreContext ):
   """
   SSR specific context to be used when loading pStore plugins that support SSR.
   """
   def __init__( self, opcode, entityManager, featureEventHandlerRegistry,
                 readyPlugins ):
      assert opcode in [ 'SsrLoad' ]
      self.opcode_ = opcode
      self.entityManager_ = entityManager
      self.featureEventHandlerRegistry_ = featureEventHandlerRegistry
      self.readyPlugins_ = readyPlugins

   def registerPluginComplete( self, name ):
      assert name not in self.readyPlugins_.plugin
      self.readyPlugins_.plugin.add( name )

   def mountsComplete( self, mg, plugin, pluginCallbackFnc ):
      def _mountsComplete():
         pluginCallbackFnc()
         self.registerPluginComplete( plugin )
      mg.close( _mountsComplete )
