#!/usr/bin/env python3
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import StageSysdbHelper

def registerCeosLabStagedBoot( entityManager ):
   sh = StageSysdbHelper.StageHelper( entityManager, 'boot' )
   sh.applicationIs( "Staged NsDut boot" )

   sh.registerStageDependency( "CriticalAgent", [] )
   sh.registerStage( "Aaa", "CriticalAgent", complete=True )
   sh.registerStage( "SuperServer", "CriticalAgent", complete=True )
   sh.registerStage( "FastClidHelper-Cli", "CriticalAgent", complete=True )
   sh.registerStage( "PhyEthtool", "CriticalAgent", complete=True )

   sh.registerStageDependency( "Fru-Plugins", [] )
   sh.registerStage( "Fru", "Fru-Plugins", timeout=60 )

   sh.registerStageDependency( "PrimaryAgent", [] )
   sh.registerStage( "KernelNetworkInfo", "PrimaryAgent", complete=True )
   sh.registerStage( "Acl", "PrimaryAgent", complete=True )
   sh.registerStage( "Smbus", "PrimaryAgent" )
   sh.registerStage( "PciBus", "PrimaryAgent", timeout=180 )
   sh.registerStage( "Scd", "PrimaryAgent" )
   sh.registerStage( "ReloadCauseAgent", "PrimaryAgent", complete=True )
   sh.registerStage( "Ebra", "PrimaryAgent", complete=True )
   sh.registerStage( "Etba", "PrimaryAgent", complete=True )
   sh.registerStage( "CapiApp", "PrimaryAgent", complete=True )

   # Adding 'InfrastructureAgent' stage before NetworkAgent stage. As of now
   # Ira is the only participating agent. This is required as Ira agent needs to
   # set the qualpath for the multi-routing agents are to run
   sh.registerStageDependency( "InfrastructureAgent", [] )
   sh.registerStage( "Ira", "InfrastructureAgent", timeout=Tac.endOfTime )

   sh.registerStageDependency( "NetworkAgent", [ 'InfrastructureAgent' ] )
   sh.registerStage( "KernelFib", "NetworkAgent", complete=True )
   sh.registerStage( "Rib", "NetworkAgent", timeout=60 )
   sh.registerStage( "Rib-vrf", "NetworkAgent", timeout=60 )
   sh.registerStage( "Ospf", "NetworkAgent", timeout=60 )
   sh.registerStage( "Ospf-vrf", "NetworkAgent", timeout=120 )
   sh.registerStage( "Ospf3", "NetworkAgent", timeout=60 )
   sh.registerStage( "Ospf3-vrf", "NetworkAgent", timeout=120 )
   sh.registerStage( "Isis", "NetworkAgent", timeout=60 )
   sh.registerStage( "Isis-vrf", "NetworkAgent", timeout=120 )
   sh.registerStage( "IpRib", "NetworkAgent", timeout=60 )
   sh.registerStage( "ConnectedRoute", "NetworkAgent", timeout=60 )
   sh.registerStage( "RouteInput", "NetworkAgent", timeout=60 )
   sh.registerStage( "Bgp", "NetworkAgent", timeout=60 )

   sh.registerStageDependency( "VrfStatusUpdate",
                               [ "NetworkAgent" ] )
   sh.registerStage( "Ira", "VrfStatusUpdate", timeout=60 )

   sh.registerStageDependency( "VrfRoutingInfoUpdate", [ "VrfStatusUpdate" ] )
   sh.registerStage( "IpRib", "VrfRoutingInfoUpdate", timeout=60 )

   sh.registerStageDependency( "IpIntfStatusUpdate", [ "VrfRoutingInfoUpdate" ] )
   sh.registerStage( "Ira", "IpIntfStatusUpdate", timeout=60 )
   sh.registerStage( "Bgp", "IpIntfStatusUpdate", timeout=60 )

   sh.registerStageDependency( "FibRouteUpdate", [ "IpIntfStatusUpdate" ] )
   sh.registerStage( "Rib", "FibRouteUpdate", timeout=60 )
   sh.registerStage( "Rib-vrf", "FibRouteUpdate", timeout=60 )
   sh.registerStage( "Bgp", "FibRouteUpdate", timeout=60 )
   sh.registerStage( "ConnectedRoute", "FibRouteUpdate", timeout=60 )
   sh.registerStage( "RouteInput", "FibRouteUpdate", timeout=60 )
   sh.registerStage( "Isis", "FibRouteUpdate", timeout=60 )
   sh.registerStage( "Isis-vrf", "FibRouteUpdate", timeout=60 )
   sh.registerStage( "Ospf", "FibRouteUpdate", timeout=60 )
   sh.registerStage( "Ospf-vrf", "FibRouteUpdate", timeout=60 )
   sh.registerStage( "Ospf3", "FibRouteUpdate", timeout=60 )
   sh.registerStage( "Ospf3-vrf", "FibRouteUpdate", timeout=60 )
