# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import StageSysdbHelper
from Toggles.StageMgrToggleLib import togglePimMaintenanceModeEnabled

# Register stage dependencies for maintEnter stage class
def registerMaintEnter( entityMgr ):
   sh = StageSysdbHelper.StageHelper( entityMgr, 'maintEnter' )
   sh.registerStageClass()
   sh.registerStage( 'EventMgr', 'begin', [], timeout=Tac.endOfTime )
   sh.registerStage( 'EventMgr', 'before_mlag', [ 'begin' ], timeout=Tac.endOfTime )
   sh.registerStage( 'Mlag', 'mlag', [ 'before_mlag' ], timeout=Tac.endOfTime )
   sh.registerStage( 'EventMgr', 'after_mlag', [ 'mlag' ], timeout=Tac.endOfTime )
   if togglePimMaintenanceModeEnabled():
      sh.registerStage( 'Pim', 'pim', [ 'after_mlag' ], timeout=Tac.endOfTime )
      sh.registerStage( 'Pim6', 'pim', [ 'after_mlag' ], timeout=Tac.endOfTime )
      sh.registerStage( 'EventMgr', 'before_bgp', [ 'pim' ],
                        timeout=Tac.endOfTime )
   else:
      sh.registerStage( 'EventMgr', 'before_bgp', [ 'after_mlag' ],
                        timeout=Tac.endOfTime )
   # Either Rib or Bgp agent runs. Register them both here. Launcher will
   # autocomplete the event for the agent that isn't runnable.
   sh.registerStage( 'Bgp', 'bgp', [ 'before_bgp' ], timeout=Tac.endOfTime )
   # Rib-vrf-<vrfName> registrations happen in the respective agents
   sh.registerStage( 'Rib', 'bgp', [ 'before_bgp' ], timeout=Tac.endOfTime )

   sh.registerStage( 'EventMgr', 'after_bgp', [ 'bgp' ], timeout=Tac.endOfTime )
   sh.registerStage( 'EventMgr', 'before_linkdown', [ 'after_bgp' ],
                     timeout=Tac.endOfTime )
   sh.registerStage( 'Mlag', 'linkdown', [ 'before_linkdown' ],
                     timeout=Tac.endOfTime )
   sh.registerStage( 'EventMgr', 'after_linkdown', [ 'linkdown' ],
                     timeout=Tac.endOfTime )
   sh.registerStage( 'EventMgr', 'before_ratemon', [ 'after_linkdown' ],
                     timeout=Tac.endOfTime )
   sh.registerStage( 'MaintenanceMode', 'ratemon', [ 'before_ratemon' ],
                     timeout=Tac.endOfTime )
   sh.registerStage( 'EventMgr', 'after_ratemon', [ 'ratemon' ],
                     timeout=Tac.endOfTime )
   sh.registerStage( 'EventMgr', 'end', [ 'after_ratemon' ], timeout=Tac.endOfTime )
   sh.initializedIs( True )

