# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import StageSysdbHelper

def registerNormalBootBarefoot( entityManager ):
   sh = StageSysdbHelper.StageHelper( entityManager, 'boot' )
   sh.applicationIs( "Barefoot normal boot" )
   sh.continueOnTimeoutIs( True )

   sh.registerStageDependency( "CriticalAgent", [] )
   sh.registerStage( "Aaa", "CriticalAgent", complete=True )
   sh.registerStage( "SuperServer", "CriticalAgent", complete=True )
   sh.registerStage( "FastClidHelper-Cli", "CriticalAgent", complete=True )
   sh.registerStage( "CleanConfigAgent", "CriticalAgent", complete=True )
   sh.registerStage( "PhyEthtool", "CriticalAgent", complete=True )
   # MaintenanceMode is started to set qualPath for Rib/ArBgp
   sh.registerStage( "MaintenanceMode", "CriticalAgent", complete=True )

   # Adding 'InfrastructureAgent' stage before NetworkAgent stage. As of now
   # Ira is the only participating agent. This is required as Ira agent needs to
   # set the qualpath as to whether which routing agents are to run
   sh.registerStageDependency( "InfrastructureAgent", [] )
   sh.registerStage( "Ira", "InfrastructureAgent", timeout=60 )

   sh.registerStageDependency( "NetworkAgent", [ 'InfrastructureAgent' ] )
   sh.registerStage( "Ebra", "NetworkAgent", timeout=60 )
   sh.registerStage( "Acl", "NetworkAgent", complete=True )
   sh.registerStage( "KernelMfib", "NetworkAgent", complete=True )
   sh.registerStage( "KernelFib", "NetworkAgent", complete=True )
   sh.registerStage( "KernelNetworkInfo", "NetworkAgent", complete=True )

   sh.registerStageDependency( "LaunchConfigUpdate", [] )
   sh.registerStage( "BfnCentral", "LaunchConfigUpdate", timeout=60 )

   sh.registerStageDependency( "LinkStatusUpdate", [ "LaunchConfigUpdate" ] )
   sh.registerStage( "BfnCentral", "LinkStatusUpdate", timeout=60 )

   sh.registerStageDependency( "Fru-Plugins", [] )
   sh.registerStage( "Fru", "Fru-Plugins", timeout=60 )

   sh.registerStageDependency( "PrimaryAgent", [ "Fru-Plugins" ] )
   sh.registerStage( "Scd", "PrimaryAgent" )
   sh.registerStage( "ReloadCauseAgent", "PrimaryAgent", complete=True )
   sh.registerStage( "PlutoSmbus", "PrimaryAgent", complete=True )
   sh.registerStage( "PLSmbusMediator", "PrimaryAgent", complete=True )
   sh.registerStage( "Smbus", "PrimaryAgent" )
   sh.registerStage( "PciBus", "PrimaryAgent", timeout=300 )

   sh.registerStageDependency( "XcvrWarm", [ "PrimaryAgent" ] )
   sh.registerStage( "Xcvr", "XcvrWarm", completeNotRunnable=True, timeout=60 )

   sh.registerStage( "BfnSlice", "HardwareAgent", enableAutoComplete=True,
         autoCompleteTimeout=1 )
   sh.registerStage( "BfnSlice-FixedSystem", "HardwareAgent",
                     completeNotRunnable=True, timeout=180 )

   sh.registerStageDependency( "HardwareAgent",
                               [ "XcvrWarm", 
                                 "LaunchConfigUpdate", 
                                 "PrimaryAgent" ] )

   sh.registerStageDependency( "SecondaryHardwareAgent", [ "HardwareAgent" ] )
   sh.registerStage( "BfnCentral", "SecondaryHardwareAgent", timeout=60 )


   sh.registerStageDependency( "BfnCapabilityUpdate", [ "SecondaryHardwareAgent" ] )
   sh.registerStage( "BfnCentral", "BfnCapabilityUpdate", timeout=60 )
