# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import StageSysdbHelper

def registerNormalBootXp( entityManager ):
   sh = StageSysdbHelper.StageHelper( entityManager, 'boot' )
   sh.applicationIs( "Xp normal boot" )

   sh.registerStageDependency( "CriticalAgent", [] )
   sh.registerStage( "Aaa", "CriticalAgent", complete=True )
   sh.registerStage( "SuperServer", "CriticalAgent", complete=True )
   sh.registerStage( "FastClidHelper-Cli", "CriticalAgent", complete=True )
   sh.registerStage( "CleanConfigAgent", "CriticalAgent", complete=True )
   sh.registerStage( "PhyEthtool", "CriticalAgent", complete=True )
   sh.registerStage( "Si5327", "CriticalAgent", complete=True )

   sh.registerStageDependency( "Fru-Plugins", [] )
   sh.registerStage( "Fru", "Fru-Plugins", timeout=60 )

   sh.registerStageDependency( "PrimaryAgent", [ "Fru-Plugins" ] )
   sh.registerStage( "Smbus", "PrimaryAgent" )
   sh.registerStage( "PciBus", "PrimaryAgent", timeout=180 )
   sh.registerStage( "Scd", "PrimaryAgent" )
   sh.registerStage( "ReloadCauseAgent", "PrimaryAgent", complete=True )

   # In MLAG configurations, some interfaces are errdisabled with "mlagissu" cause
   # during reload-delay. Need to make sure that the errdisable status is propagated
   # to interface config before the forwarding agent performs layer 1 init.

   # NOTE: ErrdisableCauseStatusUpdate needs to depend on
   # ConfigAgent/Fru-Plugins to guarantee that all
   # EthPhyIntfConfig(Desc) objects have been processed. See BUG192957
   # for more details.
   sh.registerStageDependency( "ErrdisableCauseStatusUpdate", [ "Fru-Plugins" ] )
   sh.registerStage( "Mlag", "ErrdisableCauseStatusUpdate", timeout=60 )
   sh.registerStageDependency( "ErrdisableStatusUpdate",
                               [ "ErrdisableCauseStatusUpdate" ] )
   sh.registerStage( "Ebra", "ErrdisableStatusUpdate", timeout=180 )
   sh.registerStageDependency( "PhyInitAllowed", [ "ErrdisableStatusUpdate" ] )
   sh.registerStage( "XpSlice", "PhyInitAllowed", complete=True )
   sh.registerStage( "XpSlice-FixedSystem", "PhyInitAllowed", timeout=180 )

   sh.registerStageDependency( "SecondaryHardwareAgent", [ "PrimaryAgent" ] )
   sh.registerStage( "Xcvr", "SecondaryHardwareAgent", complete=True )
   sh.registerStage( "XcvrAgent", "SecondaryHardwareAgent", complete=True )
   sh.registerStageDependency( "HardwareAgent", [ "PrimaryAgent",
                                                  "SecondaryHardwareAgent" ] )
   sh.registerStage( "XpSlice", "HardwareAgent", complete=True )
   sh.registerStage( "XpSlice-FixedSystem", "HardwareAgent", timeout=180 )
   sh.registerStage( "XpCentral", "HardwareAgent", timeout=120 )

   sh.registerStageDependency( "PlatformAgentWarm", [ "HardwareAgent" ] )
   sh.registerStage( "XpL2", "PlatformAgentWarm", complete=True )
   sh.registerStage( "XpL3Unicast", "PlatformAgentWarm", complete=True )
   sh.registerStage( "XpMact", "PlatformAgentWarm", complete=True )
   sh.registerStage( "XpQos", "PlatformAgentWarm", complete=True )
   sh.registerStage( "XpCounters", "PlatformAgentWarm", complete=True )
   sh.registerStage( "XpAcl", "PlatformAgentWarm", complete=True )
   sh.registerStage( "XpMcast", "PlatformAgentWarm", timeout=600 )

