# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import StageSysdbHelper
from Toggles.StageMgrToggleLib import toggleL2CharmHitlessRestartEnabled

# register the stage graph for StrataL2 restart
def registerStrataL2Restart( entityManager ):
   if not toggleL2CharmHitlessRestartEnabled():
      return
   sh = StageSysdbHelper.StageHelper( entityManager, 'strataL2Restart' )
   sh.applicationIs( "StrataL2 restart" )
   sh.registerStage( "StrataL2", "StrataL2MacAddrSmInit", timeout=120 )
   sh.registerStageDependency( "StrataL2ControlTableInit",
                            [ "StrataL2MacAddrSmInit" ] )
   sh.registerStage( "StrataL2", "StrataL2ControlTableInit", timeout=120 )
