# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import StageSysdbHelper
from Toggles.StageMgrToggleLib import toggleCharmL3SsuEnabled

# Register the stage graph for StrataL3Unicast restart
def registerStrataL3UnicastRestart( entityManager ):
   if not toggleCharmL3SsuEnabled():
      return
   sh = StageSysdbHelper.StageHelper( entityManager, 'strataL3UnicastRestart' )
   sh.applicationIs( "StrataL3Unicast restart" )

   # Please refer to AID/13099 for details about Charm L3 staging design.

   # AleSm works on routes review in LocalUcastConfigReplay stage, the stage
   # is completed after endOfV4SyncSent and endOfV6SyncSent are set, which
   # indicates route review has done for all the routes.
   sh.registerStage( "StrataL3Unicast", "LocalUcastConfigReplay", timeout=120 )

   # PurgeStaleEntries is invoked in LocalUcastConfigReplayDone stage for all the
   # unicast dependent and needed tables.
   sh.registerStage( "StrataL3Unicast", "LocalUcastConfigReplayDone", timeout=60 )
   sh.registerStageDependency( "LocalUcastConfigReplayDone",
                               [ "LocalUcastConfigReplay" ] )

   # doPublishHwTableMountInfo is invoked in LocalUcastHwReconcileDone stage for
   # all the unicast dependent and needed tables.
   sh.registerStage( "StrataL3Unicast", "LocalUcastHwReconcileDone", timeout=60 )
   sh.registerStageDependency( "LocalUcastHwReconcileDone",
                              [ "LocalUcastConfigReplayDone" ] )
