#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import Tracing
import StageSysdbHelper
# pkgdeps: import AsuUtil
from StageGraph.AsuHitlessBootSand import registerAsuHitlessBootSand
from StageGraph.AsuHitlessBootStrata import registerAsuHitlessBootStrata
from StageGraph.AsuHitlessBootBarefoot import registerAsuHitlessBootBarefoot
from StageGraph.AsuHitlessBootCharm import registerAsuHitlessBootCharm
from StageGraph.AsuShutdown import registerAsuShutdown
from StageGraph.MaintEnter import registerMaintEnter
from StageGraph.MaintExit import registerMaintExit
from StageGraph.NormalBoot import registerNormalBoot
from StageGraph.NormalBootXp import registerNormalBootXp
from StageGraph.NormalBootBarefoot import registerNormalBootBarefoot
from StageGraph.NormalBootMako import registerNormalBootMako
from StageGraph.CeosLabStagedBoot import registerCeosLabStagedBoot
from StageGraph.SupervisorColdBoot import registerSupervisorColdBoot
from StageGraph.StrataL2Restart import registerStrataL2Restart
from StageGraph.StrataL3UnicastRestart import registerStrataL3UnicastRestart
from StageGraph.Switchover import registerSwitchover
from StageGraphUtil import BootModeConfig
from StageGraphUtil import charmSsuSupported
from StageGraphUtil import getPlatformType

traceHandle = Tracing.Handle( 'StageGraphs' )
t0 = traceHandle.trace0

# register the stage graphs used for various boot modes
def registerBoot( entMan ):

   sh = StageSysdbHelper.StageHelper( entMan, 'boot' )
   sh.registerStageClass()
   bootModeConfig = BootModeConfig( entMan )
   bootModeConfig.bootModeStagesIs( "normalBoot", registerNormalBoot )
   bootModeConfig.bootModeStagesIs( "normalBootXp", registerNormalBootXp )
   bootModeConfig.bootModeStagesIs( "normalBootBarefoot",
                                    registerNormalBootBarefoot )
   bootModeConfig.bootModeStagesIs( "normalBootMako", registerNormalBootMako )
   bootModeConfig.bootModeStagesIs( "ceoslabStagedBoot",
                                    registerCeosLabStagedBoot )
   bootModeConfig.bootModeStagesIs( "supervisorColdBoot", registerSupervisorColdBoot
         )

   platform = getPlatformType()
   t0( "registerBoot platform:", platform )
   
   if platform == "sand":
      bootModeConfig.bootModeStagesIs( "asuHitlessBoot", registerAsuHitlessBootSand )
   elif platform == "barefoot":
      bootModeConfig.bootModeStagesIs( "asuHitlessBoot",
                                       registerAsuHitlessBootBarefoot )
   else:
      if charmSsuSupported():
         bootModeConfig.bootModeStagesIs( "asuHitlessBoot",
                                          registerAsuHitlessBootCharm )
      else:
         bootModeConfig.bootModeStagesIs( "asuHitlessBoot",
                                          registerAsuHitlessBootStrata )

   sh.initializedIs( True )

# register stage graph used for ASU shutdown
def registerShutdown( entMan ):
   sh = StageSysdbHelper.StageHelper( entMan, 'shutdown' )
   sh.registerStageClass()

   registerAsuShutdown( entMan )
   sh.initializedIs( True )

def registerHitlessRestartForGrpah( entMan, graph, regFunc ):
   sh = StageSysdbHelper.StageHelper( entMan, graph )
   sh.registerStageClass()
   regFunc( entMan )
   sh.initializedIs( True )

def registerHitlessRestart( entMan ):
   if not charmSsuSupported():
      return
   registerHitlessRestartForGrpah( entMan,
                                   'strataL2Restart',
                                   registerStrataL2Restart )
   registerHitlessRestartForGrpah( entMan,
                                   'strataL3UnicastRestart',
                                   registerStrataL3UnicastRestart )

def registerStageGraphs( entMan ):
   registerBoot( entMan )
   registerShutdown( entMan )
   registerSwitchover( entMan )
   registerHitlessRestart( entMan )
   registerMaintEnter( entMan )
   registerMaintExit( entMan )
