# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
from StageMgrPluginBase import StageMgrDynRegBase
import Tracing

_smbusStageMgrPlugin = None
traceHandle = Tracing.Handle( 'SmbusStageMgrPlugin' )
t0 = traceHandle.trace0

class SmbusStageMgrPlugin( StageMgrDynRegBase ):
   def registerDynamicStages( self ):
      t0( 'SmbusStageMgrPlugin::registerDynamicStages' )
      smbusNames = self.pstoreReader( 'Smbus', 'smbusNames',
            defaultItems=[ 'Smbus' ] )
      for smbusName in smbusNames:
         self.registerAgentName( smbusName )

   def registerAgentName( self, agentName ):
      # pylint: disable-next=consider-using-f-string
      t0( 'Registering stages for agent %s' % agentName )
      if 'Linecard' not in agentName:
         stages = [ 'PrimaryAgent' ]
      else:
         stages = [ 'XcvrWarm' ]
      for stage in stages:
         self.registerStage( agentName, stage )

def Plugin( entityManager ):
   t0( 'Loading Smbus StageMgrPlugin' )
   global _smbusStageMgrPlugin
   _smbusStageMgrPlugin = SmbusStageMgrPlugin( entityManager )
