# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from StageGraphUtil import BootModeConfig
import StageSysdbHelper
import Tracing
from AsuPStore import getAsuPStorePath
import json

traceHandle = Tracing.Handle( 'StageMgrDynRegBase' )
t0 = traceHandle.trace0

class StageMgrDynRegBase:
   def __init__( self, entityManager ):
      t0( 'StageMgrDynRegBase::__init__' )
      self.stageHelper_ = None
      bootModeConfig = BootModeConfig( entityManager )
      bootModeConfig.bootModeStagesIs( "asuHitlessBoot", self.register )

   @staticmethod
   def pstoreReader( featureName, key, defaultItems=None ):
      cfgPath = getAsuPStorePath()
      items = []
      try:
         with open( cfgPath ) as f:
            jsonConfig = json.load( f )
            keyValue = jsonConfig.get( featureName, None )
            if keyValue is not None:
               items = keyValue.get( key, {} )
            if not items:
               # pylint: disable-next=consider-using-f-string
               t0( "%s not in PSTORE or is empty." % key )
               # pylint: disable-next=consider-using-f-string
               t0( "Using defaultItems: %s" % str( defaultItems ) )
               items = defaultItems if defaultItems else []
      except ValueError:
         # pylint: disable-next=consider-using-f-string
         t0( "File %s not valid JSON format." % ( cfgPath ) )
      except OSError as e:
         # pylint: disable-next=consider-using-f-string
         t0( "Could not read %s: %s." % ( cfgPath, e ) )

      return items

   def register( self, entityManager, stageClass='boot' ):
      t0( 'StageMgrDynRegBase::register' )
      self.stageHelper_ = StageSysdbHelper.StageHelper( entityManager, stageClass )
      self.registerDynamicStages()

   def registerDynamicStages( self ):
      '''
      Override this method to register dynamic stages for the agents of interest.
      '''
      raise NotImplementedError

   def registerStage( self, agentName, stage, timeout=None, complete=None ):
      '''
      This method can be called by the child object only after register
      function has been invoked so that the correct stage helper is
      instantiated
      '''
      self.stageHelper_.registerStage( agentName, stage, timeout=timeout,
            complete=complete )
