# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import PyWrappers.Jitter as jitter
import SuperServer
import Tac
import Cell
import Tracing

t0 = Tracing.trace0

class JitterService( SuperServer.LinuxService ):
   notifierTypeName = "Mgmt::Security::Config"

   def __init__( self, mgmtConfig, jitterStatus ):
      self.config_ = mgmtConfig
      self.status_ = jitterStatus
      self.started_ = False
      SuperServer.LinuxService.__init__( self, jitter.name(),
                                         jitter.name(), self.config_,
                                         "/etc/default/jitter" )
      self.handleEntropySourceJitter()

   def startService( self ):
      t0( "Starting jitter service" )
      if not self.started_:
         SuperServer.LinuxService.startService( self )
         self.started_ = True
         self.status_.entropySourceJitterEnabled = True

   def stopService( self ):
      t0( "Stopping jitter service" )
      if self.started_:
         SuperServer.LinuxService.stopService( self )
         self.started_ = False
         self.status_.entropySourceJitterEnabled = False

   def serviceEnabled( self ):
      return self.started_ and self.config_.entropySourceJitter

   def conf( self ):
      return ""

   def serviceProcessWarm( self ):
      return self.serviceEnabled()

   @Tac.handler( 'entropySourceJitter' )
   def handleEntropySourceJitter( self ):
      t0( "Handling jitter service" )
      if self.config_.entropySourceJitter:
         self.startService()
      else:
         self.stopService()

class Jitter( SuperServer.SuperServerAgent ):
   def __init__( self, entityManager ):
      SuperServer.SuperServerAgent.__init__( self, entityManager )
      self.warm_ = False
      mg = entityManager.mountGroup()
      self.mgmtConfig = mg.mount( 'mgmt/security/config',
                                  'Mgmt::Security::Config', 'r' )
      self.jitterStatus = mg.mount( Cell.path( 'mgmt/security/jitterStatus' ),
                                    'Mgmt::Security::JitterStatus', 'w' )
      self.service_ = None

      def _finished():
         # run only if active
         if self.active():
            self.onSwitchover( None )

      mg.close( _finished )

   def onSwitchover( self, protocol ):
      self.service_ = JitterService( self.mgmtConfig, self.jitterStatus )
      self.warm_ = True

   def warm( self ):
      if not self.active():
         return True
      return self.warm_

def Plugin( ctx ):
   ctx.registerService( Jitter( ctx.entityManager ) )
