#!/usro/bin/env pytho
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import SuperServer
import os
import Tracing
from EosCloudInitLib import veosInternalConfigFile
from VeosHypervisor import platformCaravan
import Ark

traceHandle = Tracing.Handle( 'SfeVeosConfig' )
t9 = traceHandle.trace9

def getConfigFile():
   return os.environ.get( 'TEST_SFE_VEOS_CONFIG_FILE',
           veosInternalConfigFile )

class SfeBessCliConfigNotifiee( SuperServer.GenericService ):
   """ Reactor to changes in the bessCliConfig from CLI and
   updates the persistence file /mnt/flash/.veos-config-internal for
   use during next reboot cycle for kernel config use """

   notifierTypeName = 'Sfe::BessdCliConfig'

   def __init__( self, serviceName, bessCliConfig,
                cfgFile=None ):
      self.bessCliConfig = bessCliConfig
      self.cfgFile = getConfigFile() if not cfgFile else cfgFile
      SuperServer.GenericService.__init__( self, serviceName, bessCliConfig )
      t9( 'veosConfig superserver agent initialized' )

   def generateVeosConfig( self ):
      config = ''
      dpCores = self.bessCliConfig.maxDpCores
      if dpCores:
         config += f'\nmaxDataPathCores={dpCores}'
      return config

   def sync( self ):
      t9( 'sync() called' )
      self.writeConfigFile( self.cfgFile, self.generateVeosConfig(),
                            saveBackupConfig=True )

   def warm( self ):
      t9( 'warm() called' )
      return True

class VeosConfigMgr( SuperServer.SuperServerAgent ):
   """ This agent reacts to changes in the bessCli Config
   from the sfe CLIs and updates the persistent file
   appropriately. """

   def __init__( self, entityManager ):
      t9( 'Starting veosConfig updater...' )
      # Mount configurations
      SuperServer.SuperServerAgent.__init__( self, entityManager )
      mg = entityManager.mountGroup()

      bessCliConfig = mg.mount( 'bess/cli/config', 'Sfe::BessdCliConfig', 'rO' )
      self.notifiee = None

      def _finished():
         t9( 'Agent Mounted' )
         self.notifiee = SfeBessCliConfigNotifiee( "veosConfig", bessCliConfig )

      mg.close( _finished )

def Plugin( ctx ):
   platform = Ark.getPlatform()
   if platform == 'veos' or platform == "baremetal" or \
      platformCaravan():
      t9( 'Registering veosConfig updater SuperServer service' )
      ctx.registerService( VeosConfigMgr( ctx.entityManager ) )

