# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
# pkgdeps: library SwagCore

_swagStateType = Tac.Type( 'Swag::State' )
def _swagState():
   ''' Get the swag state for retrieving swag information '''
   return _swagStateType.singleton()

def memberId() -> int:
   ''' return my member id '''
   return _swagState().memberId

def activeMemberId() -> int:
   ''' return active supervisor member id '''
   return _swagState().activeMemberId

def role() -> str:
   ''' return my swag role '''
   return _swagState().role

def vlan() -> int:
   ''' return my swag vlan '''
   return _swagState().vlan

def swagMode() -> bool:
   ''' returns True if system in swag mode '''
   return _swagState().swagMode()

def memberIpAddr( mId ) -> str:
   ''' returns the ip address of a swag member '''
   return _swagStateType.memberIpAddr( mId )

def memberSubnet() -> Tac.Type( 'Arnet::IpAddrWithMask' ):
   ''' returns the ip subnet of all swag members '''
   return _swagStateType.memberSubnet()

def isMember() -> bool:
   ''' indicates if system is a member '''
   return _swagState().isMember()

def isSupervisor() -> bool:
   ''' indicates if system is a supervisor'''
   return _swagState().isSupervisor()

# TODO(BUG991589): Remove this once AgentDirectory.agentIsRunning invocations on the
# supervisor are able to query whether a SWAG-ified agent is running on a worker.
def patchAgentIsRunning( agentIsRunningFunc ):
   def func( *args, **kwargs ):
      if isSupervisor():
         return True
      return agentIsRunningFunc( *args, **kwargs )
   return func
