#!/usr/bin/env python3
# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: library SwagCore

import Tac

# Swag utility for writing swag state to the file system.
# By default, the path to store swag info is '/etc'.

# The supported swag state is:
#    /etc/swagMemberId
#    /etc/swagActiveMemberId
#    /etc/swagRole
#    /etc/swagVlan

# The destination directory can be overridden using the following env. variable:
#    SWAG_PATH

def swagFilePath( fileName ):
   ''' Helper function to get the complete path to a given swag file '''
   return Tac.Type( 'Swag::State' ).swagFilePath( fileName )

def memberIdIs( memberId ):
   ''' writes swag member id to the file system '''
   Tac.Type( 'Swag::State' ).singleton().memberId = memberId

def activeMemberIdIs( memberId ):
   ''' writes swag active member id to the file system '''
   Tac.Type( 'Swag::State' ).singleton().activeMemberId = memberId

def roleIs( role ):
   ''' writes swag role to the file system '''
   Tac.Type( 'Swag::State' ).singleton().role = role

def vlanIs( vlan ):
   ''' writes swag vlan to the file system '''
   Tac.Type( 'Swag::State' ).singleton().vlan = vlan
