# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import argparse
import os
import sys

import Swi
import Swi.create
import Swi.extract
import Swi.sign
import SwimHelperLib

def flatten( op ):
   # Use Swi.inSwi() to extract the image, flatten SWIM into SWI, re-sqsh
   # the flattened SWI, and sign the image
   Swi.inSwi( op.swim, [], fast=op.fast, outputfile=op.swi, flattenSwim=True,
              nonOverlayFlatten=op.non_overlay )
   return 0

def precheckSwimImage( swim ):
   if not os.path.exists( swim ):
      print( "Input SWIM image does not exist" )
      sys.exit( 1 )

   if not SwimHelperLib.isSwimImage( swim ):
      print( "Input image does not contain required "
             "sqsh map file" )
      sys.exit( 1 )

def flattenHandler( args=None ):
   args = sys.argv[1:] if args is None else args
   ap = argparse.ArgumentParser( prog="swi flatten" )

   ap.add_argument( "swim", metavar="EOS.swim",
                    help="Path of the SWIM image to flatten into SWI" )
   ap.add_argument( "swi", metavar="EOS.swi",
                    help="Path of output SWI image" )
   ap.add_argument( "--fast", action="store_true" )
   ap.add_argument( "--non-overlay", action="store_true",
                    help="Do not use overlay mounting of the SWIM "
                         "filesystem before duplicating it" )
   op = ap.parse_args( args )
   # Check SWIM image exists and has the expected SWIM file installed
   precheckSwimImage( op.swim )
   returnCode = flatten( op )
   exit( returnCode ) # pylint: disable=consider-using-sys-exit
