# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import argparse
import collections
import csv
import sys

import Swi
import SwimHelperLib

def licenses( rootdir ):
   cmd = [ 'rpm', '--root=' + rootdir, '-qa', '--qf=%{SOURCERPM} %{LICENSE}\n' ]
   pkgList = Swi.runAndReturnOutput( cmd, printStdout=False )
   pkgLicense = collections.defaultdict( dict )
   for line in pkgList.split( "\n" ):
      if line:
         ( pkg, l ) = line.split( ' ', 1 )
         pkgLicense[ pkg ][ l ] = True
   writer = csv.writer( sys.stdout )
   # Header
   writer.writerow( ( 'Software', 'License',
                      "Went through Arista's open source approval process?" ) )
   for pkg in sorted( pkgLicense.keys() ):
      for l in sorted( pkgLicense[ pkg ].keys() ):
         if 'Arista' in l:
            continue
         if 'Proprietary' in l:
            continue
         writer.writerow( ( pkg, l, 'YES' ) )

def licensesHandler( args=None ):
   args = sys.argv[1:] if args is None else args
   op = argparse.ArgumentParser(
         prog="swi licenses",
         description="Listing licenses of packages in a SWI file",
         usage="usage: %(prog)s [--swim-flavor <flavor>] EOS.swi" )

   _, args = op.parse_known_args( args )
   if len( args ) < 1:
      print( "Need SWI file" )

   image = args[ 0 ]

   optimization = None
   if SwimHelperLib.isSwimImage( image ):
      optimization = SwimHelperLib.getSupersetRootfs( image,
                                                      failOnMissing=True )[ 0 ]

   Swi.inSwi( image, [ licenses ], readOnly=True, optimization=optimization,
              rpmOp=True )

