# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import yaml

def verifyConfig( config ):
   assert config[ "archname" ] is not None
   assert config[ "isSwix" ] is not None
   assert config[ "payload" ] is not None
   assert config[ "payload" ][ "rpms" ] is not None
   assert config[ "rpmSpec" ] is not None
   assert config[ "rpmSpec" ][ "mountPoint" ] is not None
   assert config[ "rpmSpec" ][ "name" ] is not None
   assert config[ "rpmSpec" ][ "version" ] is not None
   assert config[ "rpmSpec" ][ "release" ] is not None

def loadConfig( path ):
   with open( path, 'r' ) as f:
      data = yaml.safe_load( f )
      verifyConfig( data )
      return data
