# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import argparse
import sys
import zipfile

def printInfo( swixPath ):
   swixZipFile = zipfile.ZipFile( swixPath ) # pylint: disable=consider-using-with
   
   textManifest = swixZipFile.read( "manifest.txt" ).decode( "utf-8" )
   print( textManifest )
   print()

   if "swix-signature" in swixZipFile.namelist():
      print( "swix-signature present (use `swix verify` to validate)" )
   else:
      print( "swix-signature absent" )

def infoHandler( args ):
   parser = argparse.ArgumentParser( prog='swix info' )
   parser.add_argument( 'swixFile', metavar='FILE.swix',
                        help='Name of SWIX file to show info about' )
   args = parser.parse_args( args )
   
   try:
      printInfo( args.swixFile )
   # The lint disable below silences python2 pylint in contentcheck.
   # Swix tool is only being run with python3.
   except FileNotFoundError as e: # pylint: disable=undefined-variable
      print( e )
      sys.exit( 1 )
