# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Based on include/linux/if_vlan.h.

VLAN_HLEN = 4  # The additional bytes (on top of the Ethernet header)
               # that VLAN requires.

VLAN_ETH_ALEN = 6          # Octets in one ethernet addr
VLAN_ETH_HLEN = 18         # Total octets in header.
VLAN_ETH_ZLEN = 64         # Min. octets in frame sans FCS
VLAN_ETH_DATA_LEN = 1500   # Max. octets in payload
VLAN_ETH_FRAME_LEN = 1518  # Max. octets in frame sans FCS

VLAN_PRIO_MASK  = 0xe000   # Priority Code Point
VLAN_PRIO_SHIFT = 13
VLAN_CFI_MASK   = 0x1000   # Canonical Format Indicator
VLAN_VID_MASK   = 0x0fff   # VLAN Identifier
