# Copyright (c) 2006-2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Plugins, Tracing, Cell
import Tac

traceHandle = Tracing.Handle( 'SysdbIntf' )
t0 = traceHandle.trace0

@Plugins.plugin( provides=('interface/status',
                           Cell.path( 'interface/status/local' ),
                           'interface/config/all', 'interface/status/all',
                           Cell.path( 'interface/nsconfig' ), ) )
def Plugin( context ):
   # Register the Interface::Intf{Config,Status}Dir's
   lookup = context.lookup
   aicd = lookup( 'interface/config*/all' )
   aisd = lookup( 'interface/status*/all' )

   # Mount the local state under /ar/SysdbIntf
   localRoot = context.root().parent
 
   # The dependency constraint SysdbEthIntf to SysdbIntf  has been removed as part 
   # of the rework to move the EthIntf SysdbPlugin to a different agent. If the
   # plugin loader has loaded the SysdbEthIntf SysdbPlugin first because
   # of the removed dependency, then it would have already created
   # the agent object. In that case, the newEntity call below will retrieve 
   # the entity already created.
   agent = localRoot.newEntity( "SysdbIntf::Agent", "SysdbIntf" )
   allIntfDir = localRoot.newEntity( "SysdbIntf::AllIntfDir", "allintfdir" )
   agent.allIntfDir = allIntfDir
   assert allIntfDir

   # this tracks which interface is in which namespace, which is a
   # kernel entity, so we do not want to copy it on switchover

   # When we are the Sysdb Active, instantiate an AllIntfReactor to
   # copy our local 'all' collection to the Sysdb-disseminated one
   def _handleActive( active ):
      if active:
         t0( "Creating locally-mounted reactors" )
         agent.allIntfReactor = ( aicd, aisd, allIntfDir.config, allIntfDir.status )
      else:
         # Note: this cleanup code is always a no-op except in testing.
         t0( "Destroying locally-mounted reactors" )
         agent.allIntfReactor = None

   context.registerActiveCallback( _handleActive )

   context.allIntfDir = allIntfDir

