#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

#
# TacMarco module that loads libTacMarco.so library and imports MarcoPython
# module. It also exports functions implemented in MarcoUtil
#

# These `pylint` directives apply to the scope level, i.e., the module.
# pylint: disable=no-name-in-module
# pylint: disable=wrong-import-position

import ctypes
ctypes.CDLL( 'libTacMarco.so', mode=ctypes.RTLD_GLOBAL )

import Tac

from MarcoPython import endOfTime
from MarcoPython import useThreadLocalSingletons
from MarcoPython import hasThreadLocalSingletons
from MarcoPython import isMainThread
from MarcoPython import _waitFor
from MarcoPython import TimeoutException
from MarcoPython import setRandomSeed
from MarcoPython import throwOnAssertFailIs
from MarcoPython import forkedChildIs
from MarcoPython import enableNetZero
from MarcoPython import is32Bit

# wrap waitFor() to avoid having to overload the function arguments using boost
def waitFor( cond, description='', timeout=600, warnAfter=1.0, delay=0.05 ):
   return _waitFor( cond, description, timeout, delay, warnAfter )
