#!/usr/bin/env python3
# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# dscp list => name: ( value, description )
# Same as dictionary defined at /src/Acl/AclCliLib.py, defined here separated to 
# avoid cyclic package dependency
dscpAclNames = {
   'af11' : ( 10, 'AF11 dscp (001010)' ),
   'af12' : ( 12, 'AF12 dscp (001100)' ),
   'af13' : ( 14, 'AF13 dscp (001110)' ),
   'af21' : ( 18, 'AF21 dscp (010010)' ),
   'af22' : ( 20, 'AF22 dscp (010100)' ),
   'af23' : ( 22, 'AF23 dscp (010110)' ),
   'af31' : ( 26, 'AF31 dscp (011010)' ),
   'af32' : ( 28, 'AF32 dscp (011100)' ),
   'af33' : ( 30, 'AF33 dscp (011110)' ),
   'af41' : ( 34, 'AF41 dscp (100010)' ),
   'af42' : ( 36, 'AF42 dscp (100100)' ),
   'af43' : ( 38, 'AF43 dscp (100110)' ),
   'cs0' : ( 0, 'Default dscp (000000)' ),
   'cs1' : ( 8, 'CS1(precedence 1) dscp (001000)' ),
   'cs2' : ( 16, 'CS2(precedence 2) dscp (010000)' ),
   'cs3' : ( 24, 'CS3(precedence 3) dscp (011000)' ),
   'cs4' : ( 32, 'CS4(precedence 4) dscp (100000)' ),
   'cs5' : ( 40, 'CS5(precedence 5) dscp (101000)' ),
   'cs6' : ( 48, 'CS6(precedence 6) dscp (110000)' ),
   'cs7' : ( 56, 'CS7(precedence 7) dscp (111000)' ),
   'ef' : ( 46, 'EF dscp (101110)' ),
   }
