# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

standardConfig = '''
[[inputs.cpu]]
  percpu = true
  totalcpu = true
  collect_cpu_time = true
  report_active = true
[[inputs.disk]]
  mount_points = ["/", "/mnt/flash", "/run", "/tmp", "/dev"]
  ignore_fs = []
[[inputs.diskio]]
[[inputs.mem]]
[[inputs.processes]]
[[inputs.swap]]
[[inputs.system]]
[[inputs.gnmi_arista]]
  targets = ["unix:///var/run/gnmiServer.sock"]
  [[inputs.gnmi_arista.subscription]]
    origin = "openconfig"
    prefix = ""
    stream_mode = "on_change"
    updates_only = false
    suppress_redundant = false
    paths = [
      "/components/component/fan/state",
      "/components/component/power-supply/state",
      "/components/component/state/temperature",
      "/interfaces/interface/state/counters",
   ]
   [[inputs.gnmi_arista.subscription.metric]]
     name = "temperature"
   path = "/components/component\\\\[name=(?P<sensor>.+)\\\\]/state/temperature/(.+)"
   [[inputs.gnmi_arista.subscription.metric]]
     name = "fans"
     path = "/components/component\\\\[name=(?P<fan>.+)\\\\]/fan/state/(.+)"
   [[inputs.gnmi_arista.subscription.metric]]
     name = "power"
     path = "/components/component\\\\[name=(?P<psu>.+)\\\\]/power-supply/state/(.+)"
   [[inputs.gnmi_arista.subscription.metric]]
     name = "intfCounters"
     path = "/interfaces/interface\\\\[name=(?P<intf>.+)\\\\]/state/counters/(.+)"

[[inputs.socket_listener]]
  service_address = "unix:///var/run/telegraf.sock"
  socket_mode = "777"
'''

def Plugin( ctx ):
   ctx.sourceGroupConfigIs( 'standard', standardConfig )
