# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import enum

import Logging
import Toggles.TpmGenericToggleLib as toggleLib

toggleSysLogEnabled = toggleLib.toggleTpmGenericSysLogOnFailureEnabled()

if toggleSysLogEnabled:
   MEASUREDBOOT_PCR_EXT_FAIL = Logging.LogHandle(
      "MEASUREDBOOT_PCR_EXT_FAIL",
      severity=Logging.logError,
      fmt="Failed to extend PCR in register %s with event %s.",
      explanation="Measured boot failed to record the fingerprint "
      "of a component and cannot be used to verify system integrity.",
      recommendedAction=Logging.CONTACT_SUPPORT )

   SECUREBOOT_STATE_LOAD_FAIL = Logging.LogHandle(
      "SECUREBOOT_STATE_LOAD_FAIL",
      severity=Logging.logError,
      fmt="Secure boot data fetch failed.",
      explanation="Secure boot data fetch failed and no further attempt will be "
      "made to load it. This error may impact information reporting and correct "
      "behavior of the feature.",
      recommendedAction=Logging.CONTACT_SUPPORT )

TPM_DATA_DIR = '/mnt/flash/tpm-data'

TCG_EVENT_FLAG = 1 << 56

SWI_FIELDS_TO_LOG = [ 'SWI_VERSION', 'SWI_RELEASE' ]

PcrEventRevision = {
   # ASU performed measurements
   'ABOOT_SWI': 0,
   'EOS_KERNEL_PARAMS': 0,
   'ABOOT_SB_CERT': 0,

   'EOS_RC_EOS': 0,
   'EOS_STARTUP_CONFIG': 0,
   'EOS_EXTENSION_INSTALL': 0,
   'EOS_EXTENSION_UNINSTALL': 0,
   'EOS_EXTENSION_INSTALL_FAILURE': 0,
   'EOS_EXTENSION_UNINSTALL_FAILURE': 0,

   'UNKNOWN_EVENT': 0,
}

class SBToggleBit( enum.IntEnum ):
   DISABLED = 0
   IGNOREARISTACRT = 1
   PASSWDINTPM = 2
   UNLOCKSPIFLASH = 3
   ENABLESPIUPDATE = 4
   MEASUREDBOOT = 5

class DefaultPcrExtend( enum.Enum ):
   NO_SWI_VERIF = 'no-swi-verification'
   NO_RC_EOS = 'no-rc-eos'
   NO_STARTUP_CONFIG = 'no-startup-config'
   NO_BOOT_EXT = 'no-boot-ext'
   NO_KERNEL_PARAMS = 'no-kernel-params'
   NO_ABOOT_PASSWD = 'no-aboot-passwd'

class PcrRegisters( enum.IntEnum ):
   ''' For more info, see AID8907 '''
   SWI = 6
   SB_CONFIG = 7
   EOS_EARLY_BOOT_CONF = 8
   EOS_STARTUP_CONFIG = 9
   EOS_EXTENSIONS = 12

class PcrEventType( enum.Enum ):
   UNKNOWN_EVENT = 0x0
   ABOOT_IMAGE = 0x1
   ABOOT_BOOT_CONFIG = 0x2
   ABOOT_CONSOLE_LOGGED = 0x3
   ABOOT_SWI = 0x4
   ABOOT_SB_CONFIG = 0x5
   ABOOT_SB_CERT = 0x6
   ABOOT_PASSWD = 0x7
   EOS_KERNEL_PARAMS = 0x100
   EOS_RC_EOS = 0x101
   EOS_STARTUP_CONFIG = 0x102
   EOS_EXTENSION_INSTALL = 0x103
   EOS_EXTENSION_UNINSTALL = 0x104
   EOS_EXTENSION_INSTALL_FAILURE = 0x105
   EOS_EXTENSION_UNINSTALL_FAILURE = 0x106
   EV_POST_CODE = TCG_EVENT_FLAG + 0x1
   EV_S_CRTM_CONTENTS = TCG_EVENT_FLAG + 0x7
   EV_EFI_VARIABLE_DRIVER_CONFIG = TCG_EVENT_FLAG + 0x80000001
   EV_EFI_PLATFORM_FIRMWARE_BLOB = TCG_EVENT_FLAG + 0x80000008

class HashAlg( enum.Enum ):
   SHA1 = 'sha1'
   SHA256 = 'sha256'

class Error( Exception ):
   def __init__( self, message='', code=0 ):
      super().__init__( message )
      self.code = code

class NoSBToggle( Error ):
   pass

class NoTpmDevice( Error ):
   pass

class NoTpmImpl( Error ):
   pass
