# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import hashlib
import os
import subprocess

from ..Defs import Error, NoTpmImpl

class TpmImpl:
   TPM_VERSION_MAJOR_STRING = ''

   def __init__( self, tpmDevice ):
      self.tpmDevice_ = tpmDevice

   @classmethod
   def probe( cls, tpmDevice ):
      assert cls.TPM_VERSION_MAJOR_STRING != '', \
             '%s: No TPM version major string' % cls.__name__

      sysfsPath = os.path.join( '/sys/class/tpm/', tpmDevice, 'tpm_version_major' )
      try:
         with open( sysfsPath ) as f:
            if f.read().splitlines()[ 0 ] == cls.TPM_VERSION_MAJOR_STRING:
               return cls( tpmDevice )
      except OSError:
         pass
      return None

   def _runBinary( self, cmd ):
      proc = subprocess.Popen( cmd, stdout=subprocess.PIPE, stderr=subprocess.PIPE )
      stdout, stderr = proc.communicate()
      if proc.returncode != 0:
         raise Error( stderr, code=proc.returncode )
      return stdout

   def newPcrHash( self ):
      raise NotImplementedError()

   def pcrRead( self, pcrIndex ):
      raise NotImplementedError()

   def pcrExtend( self, pcrIndex, pcrHash ):
      raise NotImplementedError()

   def readSbToggle( self ):
      raise NotImplementedError()
