# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

from TypeFuture import TacLazyType
import Toggles.TunnelToggleLib

EncapIdType = TacLazyType( "Tunnel::TunnelTable::EncapId" )
EncapType = TacLazyType( "Tunnel::TunnelTable::EncapType" )
TacTunnelType = TacLazyType( "Tunnel::TunnelTable::TunnelType" )
TunnelIdType = TacLazyType( "Tunnel::TunnelTable::TunnelId" )

tunnelTypeStrDict = {
   'bgpLuTunnel': 'BGP LU',
   'ldpTunnel': 'LDP',
   'staticV4Tunnel': 'Static',
   'staticV6Tunnel': 'Static IPv6',
   'bgpLuForwardingTunnel': 'BGP LU Forwarding',
   'srV6Tunnel': 'IS-IS SR IPv6',
   'srV4Tunnel': 'IS-IS SR IPv4',
   'srTeSegmentListTunnel': 'SR-TE',
   'srTePolicyTunnel': 'SR-TE Policy',
   'rsvpTunnel': 'RSVP',
   'rsvpLerTunnel': 'RSVP LER',
   'rsvpLerSubTunnel': 'RSVP LER SUB',
   'rsvpFrrTunnel': 'RSVP FRR',
   'nexthopGroupTunnel': 'Nexthop Group',
   'tiLfaTunnel': 'TI-LFA',
   'invalidTunnel': 'invalidTunnel',
   'nexthopTunnel': 'Nexthop',
   'staticTunnel': 'Static MPLS',
   'evpnVxlanTunnel': 'EVPN VXLAN',
   'srTunnel': 'IS-IS SR',
   'staticInterfaceTunnel': 'Static Interface',
   'vxlanVtepEncapTunnel': 'VXLAN VTEP Encap',
   'eosSdkSbfdSessionTunnel': 'EosSdk sBFD',
   'vxlanTunnel': 'VXLAN',
   'mldpP2mpTunnel' : 'MLDP P2MP',
   'staticMcastTunnel' : 'Static MPLS Multicast',
   'ipInIpTunnel': 'IP-in-IP',
   'srv6TransportTunnel': 'SRv6 Transport',
   'isisFlexAlgoTunnel': 'IS-IS FlexAlgo',
   'rsvpP2mpTunnel' : 'RSVP P2MP',
   'maxTunnelType': 'maxTunnelType',
}

if Toggles.TunnelToggleLib.toggleOspfSegmentRoutingTunnelEnabled():
   tunnelTypeStrDict[ 'ospfSrTunnel' ] = 'OSPF SR'

if Toggles.TunnelToggleLib.toggleDsfPhase1Enabled():
   tunnelTypeStrDict[ 'voqFabricTunnel' ] = 'VOQ Fabric'

if Toggles.TunnelToggleLib.toggleDynamicGueTunnelsEnabled():
   tunnelTypeStrDict[ 'gueTunnel' ] = 'UDP'
   
tunnelTypesReverseStrDict = { v: k for k, v in tunnelTypeStrDict.items() }

# Get the enum values for EncapType.
tunnelTypeEnumValues = tuple( [ # pylint: disable=consider-using-generator
   TunnelIdType.tunnelTypeToCliStrep( tunnelType, True )
   for tunnelType in TacTunnelType.attributes
] )

encapTypeEnumValues = tuple( [ # pylint: disable=consider-using-generator
   EncapIdType.typeCliStrep( encapType, True ) for encapType in EncapType.attributes
] )
