# Copyright (c) 2012 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import AaaApiClient
import CliCommon
import Tac
from TypeFuture import TacLazyType

AuthenAndAuthzStatus = TacLazyType( 'AaaApi::AuthenAndAuthzStatus' )

class AuthenticationError( Exception ):
   """ Error representing a failure to authenticate. """
   pass

class AuthEntry( object ):
   def __init__( self, uid, gid, privLevel, aaaAuthnId, username ):
      self.uid = uid
      self.gid = gid
      self.privLevel = privLevel 
      self.aaaAuthnId = aaaAuthnId
      self.username = username

def parseAaaResults( aaaResult, username ):
   if not aaaResult:
      raise AuthenticationError( 'Unable to auth user' )
   elif aaaResult.status != AuthenAndAuthzStatus.allSuccess:
      raise AuthenticationError( 'Bad username/password combination' )

   privLevel = AaaApiClient.parsePrivLevel( aaaResult, CliCommon.DEFAULT_PRIV_LVL )
   return AuthEntry( aaaResult.uid, aaaResult.gid, privLevel, aaaResult.sessionId,
         username )
