#!/usr/bin/env python3
# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import subprocess

import VerifyPrefdlLib

def main():
   prefdl = subprocess.check_output( [ 'genprefdl' ] )
   try:
      VerifyPrefdlLib.verifyPrefdl( prefdl )
   except VerifyPrefdlLib.VerificationError as excep:
      print( "Prefdl Verification Failure" )
      print( excep )
      exit( 1 ) # pylint: disable=consider-using-sys-exit
   print( "Prefdl Verified OK" )
   exit( 0 ) # pylint: disable=consider-using-sys-exit

if __name__ == "__main__":
   main()
