#!/usr/bin/env python3
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import Tac
import Arnet

icmpHelperInputConfigClientName = "vxlan"

VxlanTunnelType = Tac.Type( "Vxlan::VxlanTunnelType" )

def tunnelTypeToString( tunnelType ):
   tunnelTypeToStr = { VxlanTunnelType.vxlanTunnel: 'unicast',
                       VxlanTunnelType.vxlanRoutingTunnel: 'unicast',
                       VxlanTunnelType.vxlanHwHerTunnel: 'flood',
                       VxlanTunnelType.vxlanL2EcmpMemberTunnel: 'ecmp',
                       VxlanTunnelType.vxlanMcastTunnel: 'multicast' }
   return tunnelTypeToStr.get( tunnelType, '' )

def canonicalVtepString( vteps4, vteps6 ):
   vteps = ( sorted( ( str( ip ) for ip in vteps4 ), key=Arnet.IpGenAddr ) +
             sorted( ( str( ip ) for ip in vteps6 ), key=Arnet.IpGenAddr ) )
   return ' '.join( vteps )
