# Copyright (c) 2023, Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from ArPyUtils.Types import ArException

class InternalError( ArException ):
   '''A base class for exceptions which indicate that an error has occurred within
   the common infrastructure logic rather than the actual YAML data.
   '''
   def __init__( self, message, **kwargs ):
      preamble = 'Internal Library Error! Please contact the library maintainers!\n'
      super().__init__( preamble + message, **kwargs )

class ParsingError( ArException ):
   '''A base class which should be used to indicate a failure to parse YAML data.
   These failures primarily indicate malformed documents.
   '''

class SkipDocument( ArException ):
   '''A base class which should be used to indicate when a YAML document is
   unsuitable for the system in some way, but is also not neccessarily in error.
   '''
