# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BothTrace
import Tac

v = BothTrace.Var
bt0 = BothTrace.tracef0
bt1 = BothTrace.tracef1
bt5 = BothTrace.tracef5
bt8 = BothTrace.tracef8

class ZtnLogger:
   """ This class is a wrapper for BothTrace that can be passed to 'ztn' lib
   python modules in place of 'logger' that they use.
   """
   def __init__( self, ztnStatus ):
      self.status = ztnStatus

   @staticmethod
   def btStr( *args ):
      args = [ str( arg ) for arg in args ]
      s = " ".join( args )
      return v( s )

   @staticmethod
   def error( *args ):
      bt0( ZtnLogger.btStr( *args ) )

   @staticmethod
   def warn( *args ):
      bt1( ZtnLogger.btStr( *args ) )

   @staticmethod
   def info( *args ):
      bt5( ZtnLogger.btStr( *args ) )

   @staticmethod
   def debug( *args ):
      bt8( ZtnLogger.btStr( *args ) )

   def addMsg( self, msg, noDupe=False ):
      """ Used across the ZTN agent to record a message in Sysdb that gets
      used by the show commands.
      A queue of msgs with a max size of 32 is saved in Sysdb.
      """
      if noDupe and self.status.logBack().msg == msg:
         return
      if len( self.status.log ) == 32:
         self.status.log.deq()
      self.status.log.enq( Tac.Value( "Ztn::LogMsg", Tac.utcNow(), msg ) )
