# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

# The following list contains of specially handled CONFIG paths that could
# be nested. Normally, preinit profile should not contain nested CONFIG paths.
# i.e. If both the parent path a/b and child path a/b/c/d are mounted and specified
# in mount profile, parent path a/b should not be tagged CONFIG and should not be
# config mounted.
# Nested config paths can cause following bug:
# If config-replace is called for parent CONFIG path, it will empty its state,
# and the child path will become an orphaned entity.
# However, some config paths have been specially handled such that the above nested
# config bug would not happen, so they're listed as exceptions to the nested config
# check in tacMountProfileXCheck.
# NOTE: this list should be maintained with care. Please make sure that the config
# path is specially handled so that it would not cause the bug above before adding
# the parent path to this list.

allowedConfigList = [ 'hardware/xcvr/cli/config/slice',
      'interface/archer/config/eth/phy/speedgroup/slice',
      'interface/config/eth/phy/slice',
      'hardware/archer/phy/config/cli/feature/slice',
      'ip/vrf/routeDistinguisherInputDir/config',
      # The following paths would possibly cause config-replace bug and should
      # not be considered as exceptions. These paths will be removed after
      # pacakge maintainers fix the bug.
      'hardware/line/system/cli/config/slice',
      'daemon/acl/config',
      'bfd/config/app/static',
      'bfd/config/app/test' ]
