#!/usr/bin/env python3
# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
import ctypes
import Plugins

class FabDevStats(ctypes.Structure):
   _fields_ = [
      ('reserved', ctypes.c_uint32),
      ('up', ctypes.c_uint32),
      ('tx', ctypes.c_uint64),
      ('rx', ctypes.c_uint64),
      ('rxcmicdma', ctypes.c_uint64),
      ('rxcmic', ctypes.c_uint64),
      ('txactive', ctypes.c_uint64),
      ('txpoll', ctypes.c_uint64),
      ('txreclaim', ctypes.c_uint64),
      ('txbytes', ctypes.c_uint64),
      ('rxbytes', ctypes.c_uint64),
      ('rxarpinspect', ctypes.c_uint64),
      ('rxerroredpkts', ctypes.c_uint64),
   ]
   def __print__(self):
      i = 0
      for field in self._fields_:
         print( field[ 0 ] + ' : ' + str( getattr( self,
      self._fields_[ i ][ 0 ] ) ) )
         i = i + 1

class FabPluginContext:
   def __init__( self ):
      self.ioctlHandler = None
      Plugins.loadPlugins( "FabPlugin", self )

   def ioctl( self, ioctlReq ):
      assert self.ioctlHandler, "No ioctl handler registered"
      return self.ioctlHandler( ioctlReq )

   def registerIoctlHandler( self, funcHandle ):
      # Only one handler registration is allowed for now
      assert not self.ioctlHandler, self.ioctlHandler.__module__
      self.ioctlHandler = funcHandle

   def isIoctlHandlerRegistered( self ):
      return self.ioctlHandler is not None
