# Copyright (c) 2012 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pylint: disable=consider-using-f-string

# Extend ctypes.Structure.__str__ to print out structure elements

from ctypes import * # pylint: disable=W0401

c_integer_types = ( c_bool, c_byte, c_ubyte, c_short, c_ushort, c_int, c_uint,
   c_long, c_ulong, c_longlong, c_ulonglong )

c_alpha_types = ( c_char, c_wchar, c_char_p, c_wchar_p )

c_floating_point_types = ( c_float, c_double, c_longdouble )

# Copied from DosLib.Util, because don't want dependency to Dos
PyLong_AsByteArray = pythonapi._PyLong_AsByteArray # pylint: disable=W0212
PyLong_AsByteArray.argtypes = [py_object, # long_number
                               c_char_p, # string_buffer
                               c_size_t, # string_buffer_byte_length
                               c_int, # is_big_endian
                               c_int ] # is_unsigned
def packArbitraryLengthLong( val, length ):
   """
   packArbitraryLengthLong( 1<<67 ) works where
   struct.pack( "Q", 1<<67 ) won't.
   """
   a = create_string_buffer( length )
   PyLong_AsByteArray( int(val) , a, length, 1, 0 )
   return a.raw

PyLong_FromByteArray = pythonapi._PyLong_FromByteArray # pylint: disable=W0212
PyLong_FromByteArray.restype = py_object
PyLong_FromByteArray.argtypes = [c_char_p, # string_buffer
                               c_size_t, # string_buffer_byte_length
                               c_int, # is_big_endian
                               c_int ] # is_unsigned
def unpackToArbitraryLengthLong( string ):
   return PyLong_FromByteArray( string, len(string), 1, 0 )


class DiagStructure( Structure ):
   # pylint: disable=W0212
   def __str__( self ):
      s = ''
      for fields in self._fields_:
         name, ctype = fields[:2] # uninterested in fields[2] (bits)
         if ctype in c_alpha_types:
            s += '%-14s\t%s\n' % ( name, getattr( self, name ) )
         elif ctype in c_integer_types:
            v = getattr(self, name)
            s += '%-14s\t%d (0x%08x)\n' % (name, v, v )
         elif ctype in c_floating_point_types:
            v = getattr(self, name)
            s += '%-14s\t%.3f\n' % (name, v )
         elif issubclass( ctype, Array):
            if ctype._type_ in c_alpha_types:
               s += '%-14s\t%s\n' % ( name, getattr( self, name ) )
            else:
               va = getattr(self, name)
               # pylint: disable-next=unnecessary-comprehension
               s += '%-14s\t%s' % ( name, [ v for v in va[:8]] )
               if len(va)>8:
                  s += ' and %d more\n' % ( len(va)-8 )
               else:
                  s += '\n'
         else:
            s += '%-14s\t%s\n' % ( name, str( ctype ) )
      return s
   def _setRep( self, rep ):
      # cast( addressof( self ), POINTER( c_uint ))[0] = rep # (slower, don't use)
      size = sizeof( self )
      memmove(addressof(self), packArbitraryLengthLong(rep, size), size )
   
   def _getRep( self ):
      return unpackToArbitraryLengthLong( memoryview( self )[:] )
   rep = property( _getRep, _setRep )
   def rp( self, rep ):
      # Special function that sets repr and returns self.
      # Originally overloaded __init__, but that added a 1uS per instantiation.
      self.rep = rep
      return self
