"""Extreme Discovery Protocol."""
from __future__ import absolute_import 

import dpkt


class EDP(dpkt.Packet):
    __hdr__ = (
        ('version', 'B', 1),
        ('reserved', 'B', 0),
        ('hlen', 'H', 0),
        ('sum', 'H', 0),
        ('seq', 'H', 0),
        ('mid', 'H', 0),
        ('mac', '6s', b'')
        )

    def __str__(self):
        if not self.sum:
            self.sum = dpkt.in_cksum(dpkt.Packet.__str__(self))
        return dpkt.Packet.__str__(self)


class TestEDP(object):
    """
    Test basic EDP functionality.
    """

    @classmethod
    def setup_class(cls):
        cls.p = EDP(b'\x01\x00\x01\x3c\x9e\x76\x00\x1b\x00\x00\x08\x00\x27-\x90\xed\x99\x02\x00$\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0f\x02\x02\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x01\x01\x04EXOS-2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x00\x00\x04')

    def test_version(self):
        assert (self.p.version == 1)

    def test_reserved(self):
        assert (self.p.reserved == 0)

    def test_hlen(self):
        assert (self.p.hlen == 316)

    def test_sum(self):
        assert (self.p.sum == 40566)

    def test_seq(self):
        assert (self.p.seq == 27)

    def test_mid(self):
        assert (self.p.mid == 0)

    def test_mac(self):
        assert (self.p.mac == b"\x08\x00'-\x90\xed")
