#!/usr/bin/env python
# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import
import ast
import cpufabric

test = "/proc/k_serialiser_test"
sanddma = "/proc/k_serialiser_sand"
stratadma = "/proc/k_serialiser_strata"

procFiles = [
   sanddma,
   stratadma,
   test
]

class Debug( object ):
   def __init__( self, edut=None, testData=None, testFile=None ):
      self.edut = edut
      self.testData = testData
      fabPlugin = cpufabric.FabPluginContext()

      if self.testData:
         self.refresh()
      elif testFile:
         self.file = testFile
         self.refresh()
      elif edut:
         if edut.sand():
            self.file = sanddma
         elif edut.strata():
            self.file = stratadma
         else:
            raise IOError( "edut without testFile not supported on this platform" )
         self.refresh()
      elif fabPlugin.isIoctlHandlerRegistered():
         self.testData = fabPlugin.ioctl( "kser::fabdump" )
         self.refresh()
      else:
         for f in procFiles:
            try:
               open( f, "r" ).close()
               self.file = f
               self.refresh()
               return
            except IOError:
               pass

         raise IOError( "Couldn't find debug interface" )

   def refresh( self ):
      if self.testData:
         lines = self.testData
      elif self.edut:
         lines = self.edut.bashSuCmdIs( "cat {}".format( self.file ) )[ 0 ]
      else:
         lines = open( self.file ).read()

      self.data = {}
      t = ast.literal_eval( lines )
      for var, val in t.items():
         self.parseVar( var, val )

   def parseVar( self, var, val ):
      parts = var.split( "." )

      cur = self.data
      for part in parts[ :-1 ]:
         if not part in cur:
            cur[ part ] = {}
         cur = cur[ part ]
      cur[ parts[ -1 ] ] = val

