# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import

import threading
import re
import requests
from urllib3 import disable_warnings as urllib3_disable_warnings

urllib3_disable_warnings()

HEADERS = {
    'User-Agent': 'ztn-client'
}

class HttpRequestThread(threading.Thread):

    def __init__(self, address, url, timeout, log, params=None):
        threading.Thread.__init__(self)
        self.address = address
        self.url = url
        self.timeout = timeout
        self.log = log
        self.params = params
        self.response = None
        self.exception = None

    def get(self):
        self.log.info('GET %s ...' % self.url)
        if self.params:
            self.log.info("    %s" % self.params)

        try:

            self.response = requests.get(url=self.url,
                                         params=self.params,
                                         timeout=self.timeout,
                                         verify=False,
                                         allow_redirects=False,
                                         headers=HEADERS)

            self.log.info('GET %s %d' % (self.url, self.response.status_code))
            if self.response.status_code == 200:
                self.log.info("    %s" % self.response.text)
            self.exception = None

        except Exception as e:
            self.response = None
            self.exception = e
            if isinstance(e, requests.exceptions.ConnectTimeout):
                self.log.info("%s [ timed out ]", self.url)
            elif isinstance(e, requests.exceptions.ConnectionError):
                # It is possible that a ConnectionError is raised for
                # either a Network Unreachable or Connection Refused (and probably others).
                #
                # It would be useful do determine and log the actual error.
                # We should probably be able to get errno from the object
                # hierarchy but is looks difficult after inspecting the
                # requests source code.
                #
                # The representation for this exception rolls all of the context
                # up, including the socket Errno, so we just grab it from there.
                #
                ematch = re.search(r"(\[Errno.*)'\)", str(e))
                if ematch:
                    self.log.info("%s %s", self.url, ematch.groups()[0])
                else:
                    self.log.info("%s [ connection error ]", self.url)
            else:
                self.log.info("%s %s: %s", self.url, type(e), e)

        return self.response

    def run(self):
        self.get()
